class B787_10_HUD extends BaseAirliners {
    constructor() {
        super();
        this.initDuration = 7000;
    }
    get templateID() { return "B787_10_HUD"; }
    get instrumentAlias() { return "AS01B_HUD"; }
    connectedCallback() {
        super.connectedCallback();
        this.pageGroups = [
            new NavSystemPageGroup("Main", this, [
                new B787_10_HUD_MainPage()
            ]),
        ];
        this.maxUpdateBudget = 12;
    }
    disconnectedCallback() {
        window.console.log("B787 HUD - destroyed");
        super.disconnectedCallback();
    }
    Init() {
        super.Init();
    }
    onUpdate(_deltaTime) {
        super.onUpdate(_deltaTime);
    }
}
class B787_10_HUD_Element extends NavSystemElement {
    init(root) {
    }
    onEnter() {
    }
    onUpdate(_deltaTime) {
    }
    onExit() {
    }
    onEvent(_event) {
    }
}
class B787_10_HUD_MainPage extends NavSystemPage {
    constructor() {
        super("Main", "MainFrame", new B787_10_HUD_Element());
        this.attitude = new B787_10_HUD_Attitude();
        this.fma = new B787_10_HUD_NavStatus();
        this.compass = new B787_10_HUD_Compass();
        this.ils = new B787_10_HUD_ILS();
		this.vspeed = new B787_10_HUD_VSpeed();
        this.mainFrameHeight = NaN;
        this.projectionOffset = 0;
        this.slidingSystems = new Array();
        this.element = new NavSystemElementGroup([
            this.attitude,
            new B787_10_HUD_Airspeed(),
            new B787_10_HUD_Altimeter(),
            this.vspeed,
            this.fma,
            this.ils,
            this.compass
        ]);
        // this.slidingSystems.push(this.attitude);
        // this.slidingSystems.push(this.fma);
        // this.slidingSystems.push(this.compass);
        // this.slidingSystems.push(this.ils);
    }
    init() {
        super.init();
        this.mainFrame = this.gps.getChildById("MainFrame");
    }
    onUpdate(_deltaTime) {
        super.onUpdate(_deltaTime);
        this.updateProjection(_deltaTime);
    }
    updateProjection(_deltaTime) {
        if (!this.mainFrame)
            return;
        if (!isFinite(this.mainFrameHeight)) {
            let clientRect = this.mainFrame.getBoundingClientRect();
            if (clientRect.width > 0) {
                this.mainFrameHeight = clientRect.height;
            }
        }
        else {
            let horizonOffset = 0;
            {
                let planeAltitude = Simplane.getAltitude() / 3281;
                let horizonDistance = Math.sqrt(planeAltitude * (12742 + planeAltitude));
                let correction = planeAltitude / horizonDistance;
                horizonOffset += (7.0 * correction);
            }
            {
                let cameraHeight = SimVar.GetGameVarValue("CAMERA HEIGHT IN PLANE", "feet");
                let deltaFeet = cameraHeight - 5.21;
                horizonOffset += (-1.85 * deltaFeet);
            }
            {
                let xyz = Simplane.getOrientationAxis();
                horizonOffset += (-1.55 * xyz.pitch);
            }
            horizonOffset *= this.mainFrameHeight;
            this.projectionOffset = Utils.SmoothSin(this.projectionOffset, horizonOffset, 0.0075, _deltaTime);
            for (let i = 0; i < this.slidingSystems.length; i++) {
                this.slidingSystems[i].slide(this.projectionOffset);
            }
        }
    }
    onEvent(_event) {
    }
}
class B787_10_HUD_System extends B787_10_HUD_Element {
    constructor() {
        super(...arguments);
        this.elementTop = 0;
        this.slideMin = 0;
        this.slideMax = 0;
    }
    onUpdate(_deltaTime) {
        super.onUpdate(_deltaTime);
        if (!isFinite(this.elementTop) && this.htmlElement) {
            let clientRect = this.htmlElement.getBoundingClientRect();
            if (clientRect.width > 0) {
                this.elementTop = clientRect.top;
            }
        }
    }
    slide(_delta) {
        if (isFinite(this.elementTop) && this.htmlElement) {
            let delta = _delta;
            if (isFinite(this.slideMin) && delta < this.slideMin) {
                delta = this.slideMin;
            }
            if (isFinite(this.slideMax) && delta > this.slideMax) {
                delta = this.slideMax;
            }
            this.htmlElement.style.top = this.elementTop + delta + "px";
        }
    }
}
class B787_10_HUD_Airspeed extends B787_10_HUD_System {
    constructor() {
        super();
    }
    get htmlElement() {
        return this.airspeed;
    }
    init(root) {
        super.init(root);
        this.airspeed = this.gps.getChildById("Airspeed");
        this.airspeed.aircraft = Aircraft.AS01B;
        this.airspeed.gps = this.gps;
    }
    onEnter() {
        super.onEnter();
    }
    onUpdate(_deltaTime) {
        super.onUpdate(_deltaTime);
        this.airspeed.update(_deltaTime);
    }
    onExit() {
        super.onExit();
    }
    onEvent(_event) {
        super.onEvent(_event);
    }
}
class B787_10_HUD_Altimeter extends B787_10_HUD_System {
    constructor() {
        super();
    }
    get htmlElement() {
        return this.altimeter;
    }
    init(root) {
        super.init(root);
        this.altimeter = this.gps.getChildById("Altimeter");
        this.altimeter.aircraft = Aircraft.AS01B;
        this.altimeter.gps = this.gps;
    }
    onEnter() {
        super.onEnter();
    }
    onUpdate(_deltaTime) {
        super.onUpdate(_deltaTime);
        this.altimeter.update(_deltaTime);
    }
    onExit() {
        super.onExit();
    }
    onEvent(_event) {
        super.onEvent(_event);
        switch (_event) {
            case "BARO_INC":
                SimVar.SetSimVarValue("K:KOHLSMAN_INC", "number", 1);
                break;
            case "BARO_DEC":
                SimVar.SetSimVarValue("K:KOHLSMAN_DEC", "number", 1);
                break;
        }
    }
}
class B787_10_HUD_Attitude extends B787_10_HUD_System {
    get htmlElement() {
        return this.svg;
    }
    init(root) {
        super.init(root);
        this.svg = this.gps.getChildById("Horizon");
        this.svg.aircraft = Aircraft.AS01B;
        this.svg.gps = this.gps;
    }
    onEnter() {
        super.onEnter();
    }
    onUpdate(_deltaTime) {
        super.onUpdate(_deltaTime);
        var xyz = Simplane.getOrientationAxis();
        if (xyz) {
            let pitch = xyz.pitch;
            this.svg.setAttribute("pitch", (pitch / Math.PI * 180).toString());
            this.svg.setAttribute("bank", (xyz.bank / Math.PI * 180).toString());
        }
        this.svg.setAttribute("slip_skid", Simplane.getInclinometer().toString());
        this.svg.setAttribute("radio_altitude", Simplane.getAltitudeAboveGround().toString());
        this.svg.setAttribute("radio_decision_height", this.gps.radioNav.getRadioDecisionHeight().toString());
    }
    onExit() {
        super.onExit();
    }
    onEvent(_event) {
        super.onEvent(_event);
    }
}
class B787_10_HUD_VSpeed extends B787_10_HUD_System {
    constructor() {
        super();
    }
    get htmlElement() {
        return this.vsi;
    }
    init(root) {
        this.vsi = this.gps.getChildById("VSpeed");
        this.vsi.aircraft = Aircraft.AS01B;
        this.vsi.gps = this.gps;
    }
    onEnter() {
        super.onEnter();
    }
    onUpdate(_deltaTime) {
        super.onUpdate(_deltaTime);
        var vSpeed = Math.round(Simplane.getVerticalSpeed());
        this.vsi.setAttribute("vspeed", vSpeed.toString());
        if (Simplane.getAutoPilotVerticalSpeedHoldActive()) {
            var selVSpeed = Math.round(Simplane.getAutoPilotVerticalSpeedHoldValue());
            this.vsi.setAttribute("selected_vspeed", selVSpeed.toString());
            this.vsi.setAttribute("selected_vspeed_active", "true");
        }
        else {
            this.vsi.setAttribute("selected_vspeed_active", "false");
        }
    }
    onExit() {
        super.onExit();
    }
    onEvent(_event) {
        super.onEvent(_event);
    }
}
class B787_10_HUD_NavStatus extends B787_10_HUD_System {
    get htmlElement() {
        return this.fma;
    }
    init(root) {
        super.init(root);
        this.slideMax = 0;
        this.fma = this.gps.querySelector("boeing-fma");
        this.fma.aircraft = Aircraft.AS01B;
        this.fma.gps = this.gps;
        this.isInitialized = true;
    }
    onEnter() {
        super.onEnter();
    }
    onUpdate(_deltaTime) {
        super.onUpdate(_deltaTime);
        if (this.fma != null) {
            this.fma.update(_deltaTime);
        }
    }
    onExit() {
        super.onExit();
    }
    onEvent(_event) {
        super.onEvent(_event);
    }
}
class B787_10_HUD_ILS extends B787_10_HUD_System {
    get htmlElement() {
        return this.ils;
    }
    init(root) {
        super.init(root);
        this.ils = this.gps.getChildById("ILS");
        this.ils.aircraft = Aircraft.AS01B;
        this.ils.gps = this.gps;
        this.ils.showNavInfo(true);
    }
    onEnter() {
        super.onEnter();
    }
    onUpdate(_deltaTime) {
        super.onUpdate(_deltaTime);
        if (this.ils) {
            let showIls = true;
            let localizer = this.gps.radioNav.getBestILSBeacon(false);
            if (localizer.id != 0) {
                showIls = true;
            }
            this.ils.showLocalizer(showIls);
            this.ils.showGlideslope(showIls);
            this.ils.update(_deltaTime);
        }
    }
    onExit() {
        super.onExit();
    }
    onEvent(_event) {
        super.onEvent(_event);
    }
}
class B787_10_HUD_Compass extends B787_10_HUD_System {
    get htmlElement() {
        return this.svg;
    }
    init(root) {
        super.init(root);
        this.svg = this.gps.getChildById("Compass");
        this.svg.setMode(Jet_NDCompass_Display.ARC, Jet_NDCompass_Navigation.NAV);
        this.svg.aircraft = Aircraft.AS01B;
        this.svg.gps = this.gps;
    }
    onEnter() {
        super.onEnter();
    }
    onUpdate(_deltaTime) {
        super.onUpdate(_deltaTime);
        if (this.svg) {
            this.svg.update(_deltaTime);
        }
    }
    onExit() {
        super.onExit();
    }
    onEvent(_event) {
        super.onEvent(_event);
    }
}
registerInstrument("b787-10-hud-element", B787_10_HUD);
//# sourceMappingURL=B787_10_HUD.js.map